/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.MouseTracker;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.pdraw.action.CopyAction;
import DE.siemens.ad.pdraw.action.MoveFiguresAction;
import DE.siemens.ad.pdraw.action.PasteAction;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DragTracker
extends MouseTracker {
    private Dimension fTranslation;
    protected List fFiguresToMove;
    private Figure fAnchorFigure;
    private Point fAnchorInternalClickPoint;
    private int fLastX;
    private int fLastY;
    private boolean fMoved = false;
    protected Rectangle fSelectionRectangle;
    protected Rectangle fDrawingRectangle;

    private void moveFiguresBy(int dx, int dy, DrawingView view) {
        if (this.fAnchorFigure == null) {
            return;
        }
        Dimension moveVector = new Dimension(dx, dy);
        this.constrainMoveVector(moveVector);
        dy = moveVector.height;
        dx = moveVector.width;
        boolean haveMiniFigure = false;
        if (view instanceof LogoDrawingViewUDF && !view.selectionContainsFigure(((LogoDrawingUDF)view.drawing()).getEditUDFFigure())) {
            for (int i = 0; i < this.fFiguresToMove.size(); ++i) {
                if (!(this.fFiguresToMove.get(i) instanceof EditUDFFigure.MiniBlockFigure)) continue;
                dx = 0;
                moveVector.width = 0;
                haveMiniFigure = true;
                break;
            }
        }
        this.fAnchorFigure.moveBy(dx + this.fAnchorInternalClickPoint.x, dy + this.fAnchorInternalClickPoint.y);
        Dimension gridSnapVector = ((LogoDrawingView)view).getSnapVector(this.fAnchorFigure);
        if (haveMiniFigure) {
            gridSnapVector = new Dimension(0, gridSnapVector.height);
        }
        this.fTranslation = new Dimension(dx + this.fAnchorInternalClickPoint.x + gridSnapVector.width, dy + this.fAnchorInternalClickPoint.y + gridSnapVector.height);
        this.fAnchorFigure.moveBy(-(dx + this.fAnchorInternalClickPoint.x), -(dy + this.fAnchorInternalClickPoint.y));
        for (Figure figure : this.fFiguresToMove) {
            figure.getConstraint().move(this.fTranslation);
        }
    }

    public DragTracker(Figure anchor) {
        this.fAnchorFigure = anchor;
    }

    private void copyFigures(DrawingView view) {
        Editor editor = (Editor)((Object)view.editor());
        CopyAction copyAction = (CopyAction)editor.getActionFactory().getAction("CopyAction");
        PasteAction pasteAction = (PasteAction)editor.getActionFactory().getAction("PasteAction");
        editor.getActionManager().invokeAction(copyAction);
        editor.getActionManager().invokeAction(pasteAction);
    }

    private void restoreInitialFigurePositins(DrawingView view) {
        if (this.fTranslation == null) {
            return;
        }
        for (Figure figure : this.fFiguresToMove) {
            figure.getConstraint().move(new Dimension(-this.fTranslation.width, -this.fTranslation.height));
        }
    }

    private void constrainMoveVector(Dimension vector) {
        int sign;
        int correctionValue;
        Rectangle tempSelectionRectangle = (Rectangle)this.fSelectionRectangle.clone();
        tempSelectionRectangle.translate(vector.width, vector.height);
        Rectangle union = (Rectangle)this.fDrawingRectangle.createUnion(tempSelectionRectangle);
        if (tempSelectionRectangle.equals(this.fDrawingRectangle)) {
            return;
        }
        if (union.width > this.fDrawingRectangle.width) {
            correctionValue = union.width - this.fDrawingRectangle.width;
            sign = tempSelectionRectangle.x < this.fDrawingRectangle.x ? -1 : 1;
            vector.width -= correctionValue * sign;
        }
        if (union.height > this.fDrawingRectangle.height) {
            correctionValue = union.height - this.fDrawingRectangle.height;
            sign = tempSelectionRectangle.y < this.fDrawingRectangle.y ? -1 : 1;
            vector.height -= correctionValue * sign;
        }
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseDown(e, x, y, view);
        this.fLastX = x;
        this.fLastY = y;
        if (e.isControlDown()) {
            view.toggleSelection(this.fAnchorFigure);
            this.fAnchorFigure = null;
        } else if (!view.selection().contains(this.fAnchorFigure)) {
            view.clearSelection();
            view.addToSelection(this.fAnchorFigure);
        }
        this.fDrawingRectangle = view instanceof LogoDrawingViewUDF && !view.selectionContainsFigure(((LogoDrawingUDF)view.drawing()).getEditUDFFigure()) && !view.selectionContainsFigure(((LogoDrawingUDF)view.drawing()).getUDFCommentTextFigure()) ? ((LogoDrawingUDF)view.drawing()).getEditUDFFigure().getEditArea() : new Rectangle(((LogoDrawing)view.drawing()).getViewSize100());
        this.fSelectionRectangle = view.getSelectionBounds();
        this.addCommentSelectionBounds(view);
        this.fFiguresToMove = this.determinFiguresToMove(view);
        this.fAnchorInternalClickPoint = this.getAnchorInternalClickPoint(view);
    }

    private Point getAnchorInternalClickPoint(DrawingView view) {
        Point anchorInternalClickPoint;
        LogoGridConstrainer gridConstrainer = (LogoGridConstrainer)view.getConstrainer();
        if (this.fAnchor != null && gridConstrainer != null && gridConstrainer.getStepX() > 40 && this.fAnchorFigure instanceof BlockFigure) {
            Point anchorAlingnmentAnchor = this.fAnchorFigure.getAlignmentAnchor();
            anchorInternalClickPoint = new Point(this.fAnchor.x - anchorAlingnmentAnchor.x, this.fAnchor.y - anchorAlingnmentAnchor.y);
        } else {
            anchorInternalClickPoint = new Point(0, 0);
        }
        return anchorInternalClickPoint;
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseDrag(e, x, y, view);
        if (this.fSelectionRectangle == null) {
            return;
        }
        if (view instanceof LogoDrawingViewUDF && !view.selectionContainsFigure(((LogoDrawingUDF)view.drawing()).getEditUDFFigure())) {
            Vector selection = view.selection();
            for (int i = 0; i < view.selectionCount(); ++i) {
                if (!(selection.get(i) instanceof EditUDFFigure.MiniBlockFigure)) continue;
                x = this.fLastX;
            }
            this.fMoved = true;
        } else {
            boolean bl = this.fMoved = Math.abs(x - this.fAnchor.x) > 4 || Math.abs(y - this.fAnchor.y) > 4;
        }
        if (this.fMoved) {
            int dx = x - this.fLastX;
            int dy = y - this.fLastY;
            if (e.isShiftDown()) {
                dy = Math.abs(dx) >= Math.abs(dy) ? 0 : dy;
                dx = Math.abs(dy) > Math.abs(dx) ? 0 : dx;
            }
            this.moveFigures(view, new Dimension(dx, dy));
        }
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        super.mouseUp(e, x, y, view);
        if (!this.fMoved) {
            return;
        }
        this.restoreInitialFigurePositins(view);
        this.invokeMoveAction(view, this.fTranslation);
    }

    private void invokeMoveAction(DrawingView view, Dimension translationVector) {
        ActionManager actionManager = ((Editor)((Object)view.editor())).getActionManager();
        MoveFiguresAction moveAction = new MoveFiguresAction();
        moveAction.setOwner((Editor)((Object)view.editor()));
        moveAction.setMoveVector(translationVector);
        moveAction.setSelectedFigures(new Vector(this.fFiguresToMove));
        actionManager.invokeAction(moveAction);
    }

    private void moveFigures(DrawingView view, Dimension moveVector) {
        this.restoreInitialFigurePositins(view);
        this.moveFiguresBy(moveVector.width, moveVector.height, view);
    }

    private List determinFiguresToMove(DrawingView view) {
        Vector selectedFigures = view.selection();
        ArrayList<Figure> figuresToMove = new ArrayList<Figure>(selectedFigures.size());
        for (Figure f : selectedFigures) {
            EditUDFFigure editUdfFigure;
            Figure observedFigure;
            if (f instanceof CommentTextFigure && selectedFigures.contains(observedFigure = ((CommentTextFigure)f).getObservedFigure()) || view instanceof LogoDrawingViewUDF && selectedFigures.contains(editUdfFigure = ((LogoDrawingUDF)view.drawing()).getEditUDFFigure()) && f instanceof EditUDFFigure.MiniBlockFigure) continue;
            figuresToMove.add(f);
        }
        return figuresToMove;
    }

    public void keyDown(KeyEvent evt, int key, DrawingView view) {
        super.keyDown(evt, key, view);
        if (view.selection() == null || view.selection().isEmpty()) {
            return;
        }
        this.fDrawingRectangle = view instanceof LogoDrawingViewUDF && !view.selectionContainsFigure(((LogoDrawingUDF)view.drawing()).getEditUDFFigure()) ? ((LogoDrawingUDF)view.drawing()).getEditUDFFigure().getEditArea() : new Rectangle(((LogoDrawing)view.drawing()).getViewSize100());
        this.fSelectionRectangle = view.getSelectionBounds();
        this.addCommentSelectionBounds(view);
        this.fFiguresToMove = this.determinFiguresToMove(view);
        this.fAnchorInternalClickPoint = new Point(0, 0);
        int dx = 0;
        int dy = 0;
        int stepX = 1;
        int stepY = 1;
        if (view.getConstrainer() != null) {
            stepX = view.getConstrainer().getStepX();
            stepY = view.getConstrainer().getStepY();
        }
        switch (key) {
            case 40: {
                dy = stepY;
                break;
            }
            case 38: {
                dy = -stepY;
                break;
            }
            case 39: {
                dx = stepX;
                break;
            }
            case 37: {
                dx = -stepX;
            }
        }
        if (view instanceof LogoDrawingViewUDF && !view.selectionContainsFigure(((LogoDrawingUDF)view.drawing()).getEditUDFFigure())) {
            for (int i = 0; i < this.fFiguresToMove.size(); ++i) {
                if (!(this.fFiguresToMove.get(i) instanceof EditUDFFigure.MiniBlockFigure)) continue;
                dx = 0;
                break;
            }
        }
        this.fTranslation = new Dimension(dx, dy);
        this.constrainMoveVector(this.fTranslation);
        if (!(this.fFiguresToMove.isEmpty() || this.fTranslation.width == 0 && this.fTranslation.height == 0)) {
            this.invokeMoveAction(view, this.fTranslation);
            LogoDrawingView logoDrawingView = (LogoDrawingView)view;
            Rectangle selectionBounds = logoDrawingView.getSelectionBounds();
            logoDrawingView.scrollRectToVisible(selectionBounds);
        }
    }

    private void addCommentSelectionBounds(DrawingView view) {
        if (!(view instanceof LogoDrawingViewUDF)) {
            return;
        }
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (!(f instanceof BlockFigure) || ((BlockFigure)f).getCommentFigure() == null || view.selectionContainsFigure(((BlockFigure)f).getCommentFigure())) continue;
            this.fSelectionRectangle.add(((BlockFigure)f).getCommentFigure().displayBox());
        }
    }
}

